/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.shed;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class BitField<E extends Enum<E>>
implements Iterable<E>,
Serializable {
    private static final long serialVersionUID = 3203876204846746524L;
    private final EnumSet<E> bits;

    public static <E extends Enum<E>> BitField<E> noneOf(Class<E> elementType) {
        return new BitField<E>(elementType, false);
    }

    public static <E extends Enum<E>> BitField<E> allOf(Class<E> elementType) {
        return new BitField<E>(elementType, true);
    }

    public static <E extends Enum<E>> BitField<E> of(E bit) {
        return new BitField<E>(bit);
    }

    @SafeVarargs
    public static <E extends Enum<E>> BitField<E> of(E bit, E ... bits) {
        return new BitField(bit, bits);
    }

    public static <E extends Enum<E>> BitField<E> copyOf(Collection<E> bits) {
        return new BitField<E>(EnumSet.copyOf(bits));
    }

    public static <E extends Enum<E>> BitField<E> of(Class<E> elementType, String list) {
        EnumSet<E> bits = EnumSet.noneOf(elementType);
        for (String bit : list.split("\\|")) {
            bits.add(Enum.valueOf(elementType, bit));
        }
        return new BitField<E>(bits);
    }

    private BitField(Class<E> elementType, boolean allOf) {
        this.bits = allOf ? EnumSet.allOf(elementType) : EnumSet.noneOf(elementType);
    }

    private BitField(E bit) {
        this.bits = EnumSet.of(bit);
    }

    @SafeVarargs
    private BitField(E bit, E ... bits) {
        this.bits = EnumSet.of(bit, bits);
    }

    private BitField(EnumSet<E> bits) {
        assert (null != bits);
        this.bits = bits;
    }

    public boolean isEmpty() {
        return this.bits.isEmpty();
    }

    public int cardinality() {
        return this.bits.size();
    }

    public boolean get(E bit) {
        return this.bits.contains(bit);
    }

    public boolean is(E bit) {
        return this.bits.contains(bit);
    }

    public BitField<E> set(E bit, boolean set) {
        Object bits;
        if (set) {
            if (this.bits.contains(bit)) {
                return this;
            }
            bits = this.bits.clone();
            ((AbstractCollection)bits).add(bit);
        } else {
            if (!this.bits.contains(bit)) {
                return this;
            }
            bits = this.bits.clone();
            ((AbstractCollection)bits).remove(bit);
        }
        return new BitField<E>(bits);
    }

    public BitField<E> set(E bit) {
        return this.set(bit, true);
    }

    public BitField<E> clear(E bit) {
        return this.set(bit, false);
    }

    public BitField<E> not() {
        return new BitField<E>(EnumSet.complementOf(this.bits));
    }

    public BitField<E> and(BitField<E> that) {
        Object bits = this.bits.clone();
        return ((AbstractCollection)bits).retainAll(that.bits) ? new BitField<E>(bits) : this;
    }

    public BitField<E> or(BitField<E> that) {
        Object bits = this.bits.clone();
        return ((AbstractCollection)bits).addAll(that.bits) ? new BitField<E>(bits) : this;
    }

    @Override
    public Iterator<E> iterator() {
        return Collections.unmodifiableSet(this.bits).iterator();
    }

    public EnumSet<E> toEnumSet() {
        return this.bits.clone();
    }

    public boolean equals(@Nullable Object that) {
        return this == that || that instanceof BitField && this.bits.equals(((BitField)that).bits);
    }

    public int hashCode() {
        return this.bits.hashCode();
    }

    public String toString() {
        int capacity = this.bits.size() * 11;
        if (0 >= capacity) {
            return "";
        }
        StringBuilder s = new StringBuilder(capacity);
        for (Enum bit : this.bits) {
            if (s.length() > 0) {
                s.append('|');
            }
            s.append(bit);
        }
        return s.toString();
    }
}

